<?php
/**
 Plugin Name: WooCommerce Serfinsa
 Plugin URI:
 Description: Plugin de Serfinsa para WooCommerce
 Version: 1.2.2-RELEASE
 Requires at least: woordpres 5.2
 Requires PHP: 5
 Author: Servicios Financieros S.A de C.V
 Author URI: www.redserfinsa.com
 License: All Right reserver
 **/
require_once 'includes/Serfinsa_Gateway.php';
if (! defined('ABSPATH'))
    exit();

add_action('plugins_loaded', 'woocommerce_serfinsa_init');

add_action('rest_api_init', function () {
    register_rest_route('woocomerce_serfinsa/v1', '/endpoint', array(
        'methods' => 'GET',
        'callback' => 'woocommerce_serfinsa_endpoint'
    ));
});

add_action('rest_api_init', function () {
    register_rest_route('woocomerce_serfinsa/v1', '/endpoint', array(
        'methods' => 'POST',
        'callback' => 'woocommerce_serfinsa_endpoint_post'
    ));
});

function typed_script_init()
{
    wp_enqueue_script('typedJS', 'https://pro.crunchify.com/typed.min.js', array(
        'jquery'
    ));
}
add_action('wp_enqueue_scripts', 'typed_script_init');

function typed_init()
{
    echo '<script>
	jQuery(function($){
      		$(".element").typed({
      	 	strings: ["App Shah...", " an Engineer (MS)...","a WordPress Lover...", "a Java Developer..."],
      	 	typeSpeed:100,
     		backDelay:1000,
     		loop:true
	});
     });</script>';
}
add_action('wp_footer', 'typed_init');

function woocommerce_serfinsa_init()
{

    class WC_Payment_Serfinsa extends WC_Payment_Gateway
    {

        public function __construct()
        {
            global $woocommerce;
            $this->log = new WC_Logger();
            $this->id = 'serfinsa';
            $this->has_fields = false;
            $this->order_button_text = __('Paga con Serfinsa', 'woocommerce');
            $this->method_description = 'Servicios Financieros SA de CV; Red multibanco de procesamiento de transacciones de pago POS y ATMs m&aacute;s grande de El Salvador';
//             $this->title = 'VISA/MASTERCARD - SERFINSA/Red de Bancos m&aacute;s grande de El Salvador';
//             $this->method_title = ' SERFINSA/Red de Bancos ms grande de El Salvador   Aceptamos todas las tarjetas de las marcas Visa y Mastercard.';
//             $this->title = 'SERFINSA - Visa/Mastercard';
            $this->title = 'Red SERFINSA - Aceptamos pagos con tarjetas de las marcas Visa y Mastecard.';
            $this->method_title = ' SERFINSA - Aceptamos todas las tarjetas de las marcas Visa y Mastercard.';
            $this->inti_form_fields();
            $this->init_settings();

            $this->insertJQuery = 'yes' === $this->get_option('insertJQuery', 'no');
            $this->testmode = 'yes' === $this->get_option('testmode', 'no');
            $this->debug = 'yes' === $this->get_option('debug', 'no');
            $this->sandbox_api_key = $this->get_option('sandbox_api_key');
            $this->live_api_key = $this->get_option('live_api_key');
            $this->domainName = $this->get_option('domainName');
//             $this->description = 'Servicios Financieros SA de CV; Red multibanco - Procesador de pagos electr&oacute;nicos m&aacute;s grande de El Salvador';
            $this->description = 'Servicios Financieros SA de CV: Red de Bancos m&aacute;s grande de El Salvador, somos especialistas en el procesamiento de transacciones electr&oacute;nicas (POS/ATMs).';
            // hook para opciones administrativas
            add_action('woocommerce_update_options_payment_gateways_' . $this->id, array(
                $this,
                'process_admin_options'
            ));

            add_action('woocommerce_receipt_' . $this->id, array(
                $this,
                'pay_for_order'
            ));
        }

        // here, prepare your form and submit it to the required URL
        public function pay_for_order($order_id)
        {
            global $serfinsaApi;
            $order = new WC_Order($order_id);
            // $serfinsaApi = new Serfinsa_Gateway($this->sandbox_api_key, $this->live_api_key, $this->testmode, $this->insertJQuery, false);
            $serfinsaApi = new Serfinsa_Gateway($this->sandbox_api_key, $this->live_api_key, $this->testmode, $this->insertJQuery, false, $this->domainName);
            $amount = $this->get_order_total();
            $orderItems = $order->get_items();

            include ('checkout.php');
        }

        public function inti_form_fields()
        {
            $this->form_fields = array(
                'enable' => array(
                    'title' => __('Activar/Desactivar', 'woocommerce'),
                    'type' => 'checkbox',
                    'label' => __('Activar pagos con Serfinsa', 'woocommerce'),
                    'default' => 'yes'
                ),
                'sandbox_api_key' => array(
                    'title' => __('SANDBOX KEY', 'woocommerce'),
                    'type' => 'text',
                    'custom_attributes' => array(
                        'maxlength' => 40
                    ),
                    'description' => __('Llave para ambiente de TEST proporcionada por SERFINSA', 'woocommerce'),
                    'default' => __('', 'woocommerce'),
                    'desc_tip' => true
                ),
                'live_api_key' => array(
                    'title' => __('LIVE KEY', 'woocommerce'),
                    'type' => 'text',
                    'custom_attributes' => array(
                        'maxlength' => 40
                    ),
                    'description' => __('Llave para ambiente productivo proporcionada por SERFINSA', 'woocommerce'),
                    'default' => __('', 'woocommerce'),
                    'desc_tip' => true
                ),
                'testmode' => array(
                    'title' => __('Serfinsa Sandbox', 'woocommerce'),
                    'type' => 'checkbox',
                    'label' => __('Activar ambiente de pruebas', 'woocommerce'),
                    'description' => 'El ambiente sandbox no tiene costos o aranceles adicionales, es parte de los servicios de integracion que serfinsa pone a disposicion para sus clientes.',
                    'default' => 'yes'
                ),
                'insertJQuery' => array(
                    'title' => __('Serfinsa JQuery', 'woocommerce'),
                    'type' => 'checkbox',
                    'label' => __('Activar Compatibilidad', 'woocommerce'),
                    'description' => 'Esta opcion activa/desactiva la compatibildad con worpress cuando existen conflictos',
                    'default' => 'no'
                ),
                'domainName' => array(
                    'title' => __('Domain Name', 'woocommerce'),
                    'type' => 'text',
                    'custom_attributes' => array(
                        'maxlength' => 100
                    ),
                    'description' => __('Nombre de dominio del Site ejemplo: https://mi-tienda-online.com', 'woocommerce'),
                    'default' => __('http://localhost/wordpress', 'woocommerce'),
                    'desc_tip' => true
                )
            );
        }

        public function process_payment($order_id)
        {
            session_start();

            global $wp;
            global $woocommerce;
            include_once dirname(__FILE__) . '/includes/Serfinsa_Gateway.php';

            $order = wc_get_order($order_id);

            try {
                return array(
                    'result' => 'success',
                    'redirect' => $order->get_checkout_payment_url(true)
                );
            } catch (Exception $e) {
                $order->update_status('Failed', __('failed cheque payment', 'woocommerce'));
                wc_add_notice($e->getMessage(), 'error');
                return;
            }
        }

        public function get_icon()
        {
            $icon_html = '';
            return apply_filters('woocommerce_gateway_icon', $icon_html, $this->id);
        }
    }

    function add_woo_serfinsa_gateway($methods)
    {
        $methods[] = 'WC_Payment_Serfinsa';
        return $methods;
    }

    add_filter('woocommerce_payment_gateways', 'add_woo_serfinsa_gateway');
    add_filter('woocommerce_thankyou_order_received_text', 'woo_payment_serfinsa_change_order_status', 10, 2);

    function woocommerce_serfinsa_endpoint($request)
    {
        echo 'test endpoint get ok';
    }

    function woocommerce_serfinsa_endpoint_post($request)
    {
        $response = $request->get_body();
        $obj = json_decode($response);
        try {

            if ($obj->{'Codigo'} == '00') {
                $order = wc_get_order($obj->{'ClientIdTransaction'});
                $order->add_order_note(__('Pago Completado, referencia de pago: ' . $obj->{'NumeroAutorizacion'} . ' CardPayment: ' . $obj->{'MaskPan'}, 'woocommerce'), 1);
                $order->update_meta_data('autorizacion_code', $obj->{'NumeroAutorizacion'});
                $order->update_meta_data('date_payment', $obj->{'Fecha'});
                $order->update_meta_data('card_payment', $obj->{'MaskPan'});
                $order->update_meta_data('card_holder', $obj->{'CardHolder'});
                $order->update_meta_data('payment_name', 'SERFINSA');
                $order->save();
                $order->payment_complete($obj->{'NumeroAutorizacion'});
            }

            return $obj->{'Codigo'};
        } catch (Exception $e) {
            echo $e;
        }
    }

    function woo_payment_serfinsa_change_order_status($str, $order)
    {
        global $woocommerce;
        global $wp;
        $order_id = apply_filters('woocommerce_thankyou_order_id', absint($wp->query_vars['order-received']));
        $order_key = apply_filters('woocommerce_thankyou_order_key', empty($_GET['key']) ? '' : wc_clean($_GET['key']));

        $orderI = new WC_Order($order_id);
        $order_data = $orderI->get_data();
        $orderItems = $orderI->get_items();
        $amount = $orderI->get_total();

        $order_meta = get_post_meta($order_id);
        $Autorizacion = $order_meta['autorizacion_code'][0];
        $payment_date = $order_meta['date_payment'][0];
        $card_payment = $order_meta['card_payment'][0];

        // $new_str='';

        // try {
        $payment_name = '';
        try {
            $payment_name = $order_meta['payment_name'][0];
        } catch (Exception $e) {}

        include ('checkout_thankyou.php');
        return $new_str;
        // return $new_str;
    }

    function enqueue_my_scripts()
    {
        wp_enqueue_script('payment', plugin_dir_url(__FILE__) . 'public/js/payment.js', array(
            'jquery'
        ), false, true);
    }

    add_action('wp_enqueue_scripts', 'enqueue_my_scripts');
}

?>